USE Obfuscation;

IF OBJECT_ID( 'tePerson' ) IS NOT NULL
    DROP TABLE tePerson;

GO

CREATE TABLE tePerson(
    PersonID INT NOT NULL CONSTRAINT pkPerson PRIMARY KEY CLUSTERED,
    FirstName VARCHAR(20) NOT NULL,
    LastName VARCHAR(20) NOT NULL,
    SSN CHAR(9) NOT NULL,
    DOB DATE NOT NULL
);

GO

-- insert the test data
INSERT INTO tePerson(
    PersonID,
    FirstName,
    LastName,
    SSN,
    DOB
)
SELECT 
    PersonID = ROW_NUMBER() OVER(ORDER BY FirstName),
    A.FirstName,
    B.LastName,
    SSN = ( 
        SELECT Value
        FROM vSSNs
        WHERE ID = (ABS(CHECKSUM(NEWID())) % 10000000 )
    ),
    DOB = DATEADD( d, CONVERT( INT, (ABS(CHECKSUM(NEWID())) % 10000)*-1 ), '1985-01-01' )
FROM (
    SELECT FirstName = 'George' UNION ALL
    SELECT 'Michael' UNION ALL
    SELECT 'Jessica' UNION ALL
    SELECT 'Angela' UNION ALL
    SELECT 'Doug'
) AS A
CROSS JOIN (
    SELECT LastName = 'Brown' UNION ALL
    SELECT 'White' UNION ALL
    SELECT 'Black' UNION ALL
    SELECT 'Smith' UNION ALL
    SELECT 'Jones'
) AS B

-- see the test data
SELECT *
FROM tePerson

